;This is a program is the first program exercise for Chapter 12 of PIC-MCU Programming for 
;Beginners text.  The program sets up the comparator resources as a stand alone
;resource with the comparator output (RA2) connected and ties to an LED through
;a current limiting resistor, a voltage divider tied to RA0 (the + comparator input)
;and a varible resistor tied to RA1.  When the variable resistor is adjusted to change
;the voltage on RA1, the comparator output and LED respond accordingly.  The main
;part of the program is simply a goto loop.  This demonstrates that the MCU program
;is running independent of the comparator. 



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80


;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC		;clear port bus

	movlw	b'00000001'	;non-inverted, comp with output
						;comparator with non-inverted output,
						;+/- inputs connected CM2:CM0 = 001, 
						;COUT connected to RA2 - use in step one of exercise

;	movlw	b'00010001'	;inverted, comp with output
						;comparator with inverted output,
						;+/- inputs connected CM2:CM0 = 001,
						;COUT connected to RA2 - use in step two of exercise

;	movlw	b'00000010' ;non-inverted, comp without output
						;comparator with non inverted output, 
						;+/- inputs connected CM2:CM0 = 010, COUT not connected
						;to RA2, must be read in software - used in step three of exercise


	movwf	CMCON		;
	movlw	b'00000000'	;load w reg
	movwf	INTCON
	BANKSEL	Bank1		; BANK1
	movlw	b'00000000'	;load w reg  
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00000011'	;load w reg, RA0 and RA1 input, others output 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;load w reg all output
	movwf	TRISC		;program PORTC
	movlw	b'00000011'	;RA0, RA1 is analog, all other digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
	
;end pic initialization

;*****************************************************************************
;main program
main
	goto main

;*****************************************************************************
	end
